<?php
/**
 * Measure site's rendering time.
 * @author Krzysztof Szafranek
 * @link http://szafranek.net
 * @version 1.0
 */
class Benchmark {
	/**
	 * @var float time the test was started
	 */
	var $start_time;
	/**
	 * @var float time the test was stopped
	 */
	var $end_time;
	/*
	 * Start the measurement. Store the initial time.
	 */
	function start() {
		list($msec, $sec) = explode(' ', microtime());
		$this->start_time = (float)$sec + (float)$msec;
	}
	/*
	 * Stop the measurement. Store the end time.
	 */
	function stop() {
		list($msec, $sec) = explode(' ', microtime());
		$this->end_time = (float)$sec + (float)$msec;
	}
	/*
	 * The final result.
	 * @return float measured site's load time 
	 */
	function getTime() {
		return $this->end_time - $this->start_time;
	}
	/*
	 * Reload the site to repeat the test. Store results to a file.
	 * @param string the file results will be stored to.
	 * @param integer how many times test should be repeated
	 */
	function repeatTest($results_file, $repeat = 100) {	
		if (!$results_file) {
			die('You must specify file to write data to!');
		}
		$fh = fopen($results_file, 'a');
		fputs($fh, $this->getTime()."\n");
		fclose($fh);
		if (count(file($results_file)) < $repeat) {
			echo '<script type="text/javascript">location.reload();</script>';
		} else {
			$times = file($results_file);
			$sum = 0;
			foreach ($times as $time) {
				$sum += (float) $time;
			}
			$fh = fopen($results_file, 'a');
			fputs($fh, "\naverage time: ".($sum/count($times))." seconds");
			fclose($fh);
		}
	}
}

?>